 
#ifndef _1_SST_TST_UTIL_h_H
#define _1_SST_TST_UTIL_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "SST_SEP_TST.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Mar 28 12:06:34 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version SST_TST_UTIL.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/************************ Defines *******************************/


	/*[EinatR] compare between 2 SSTHandle_t
	returns 0 if handles are identical	*/

#define SST_HANDLE_COMPARE(handle1,handle2)	\
		DX_VOS_MemCmp(&handle1,&handle2,sizeof(handle1))

/************************ Enums *********************************/
/************************ Typedefs  *****************************/
/************************ Structs  ******************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/

//int ATP_LOG_TST( DxUint8_t level , const char *pStr);

//#define ATP_LOG_TST_PRINT(args) (ATP_LOG_TST args)


/********************************************************************************
* Function Name:                                                           
* 	ATP_LOG_TST_PRINT 		
* 
* Inputs:
* 	DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
*                    flag setting it will not be printed.
* 	const char format,... - the printf format.	 
*  
* Outputs:
*   None	    					  		
*
* Description:																	
* The following function handles the printings logging of the testing suite . 
*        This function should be called by using the ATP_LOG_TST_PLOT macro
*
********************************************************************************/							     

//void ATP_LOG_TST( DxUint8_t level , const char *format,... );


//#define ATP_LOG_TST_PRINT(args) (ATP_LOG_TST args)
				
///*****************************************************************************
// * Function Name:                                                           
// * 	TST_CheckErrorReturn 		
// * 
// * Inputs:
// * 	DxUint32_t  TST_ErrorRet - The return value of the checked function
// *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
// *  char 	 TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
// *  char 	 TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name 
// *
// * Outputs:
// * 	DxError_t - Function error return		    					  		
// *
// * Description:																	
// * This function Is a utility function to save up some space 
// * this function returns the appropriate printing for a checked function 
// * If the operation had Succeeded of failed	the appropriate printing and return value
// *
// ******************************************************************************/
//DxError_t TST_CheckErrorReturn(DxError_t TST_ErrorRet, char*  TST_FuncName);

/*****************************************************************************
 * Function Name:                                                           
 *  TST_CheckExpectedErrorReturn        
 * 
 * Inputs:
 *  DxUint32_t TST_ErrorRet - The return value of the checked function
 *  DxUint32_t TST_ExpectedError - The expected return value of the checked function
 *  char     TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name 
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxError_t - Function error return                                     
 *
 * Description:                                                                 
 * This function Is a utility function to save up some space 
 * this function returns the appropriate printing for a checked function
 * comparing the received result Vs the expected result 
 * If the operation had Succeeded of failed the appropriate printing and return value
 *
 ******************************************************************************/
DxError_t TST_CheckExpectedErrorReturn(DxError_t TST_ErrorRet, 
                                          DxError_t TST_ExpectedError, 
                                          char         TST_FuncName[TST_FUNC_STRING_LEN],
                                          char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                          char         TST_MasterTestName[TST_FUNC_STRING_LEN]);

/*****************************************************************************
 * Function Name:                                                           
 *  SST_TST_RunAllAcceptance_tests         
 * 
 * Inputs:
 *  none
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 * This function runs all of the Acceptance tests
 *
 ******************************************************************************/
//DxError_t SST_TST_RunAllAcceptance_tests(void);

/*****************************************************************************
* Function Name:
* SST_ATP_TST_ShowSSTVersion
* Inputs:
*  none
*
* Description:
* This function prints the SST version and sub versions
*
******************************************************************************/
void SST_ATP_TST_ShowSSTVersion(void);
//DxUint32_t DX_SEP_SST_Init (DxUint32_t* msg);
#ifdef __cplusplus
}
#endif

#endif


